dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 3, 270, 220, "assets/images/table/ballroom", "assets/images/food/item_mark3", "R" );
LManager:AddNewTable( 2, 3, 230, 350, "assets/images/table/ballroom", "assets/images/food/item_mark2", "R" );
LManager:AddNewTable( 3, 3, 300, 480, "assets/images/table/ballroom", "assets/images/food/item_mark1", "R" );

useFloAsServer = 1;
useWineTable = 0;
numMoodBoosts = 0;
numServers = 1;
maxCoupleHappiness = 200;

-- Group 1
guest = LManager.GenGuest(female03);
guest.likes = {male04};
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = table1;
guest.percentRequestTissue = 30;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = aunt;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(1, 4, 3000);

-- Group 2

guest = LManager.GenGuest(male01);
guest.likes = {female03};
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = table3;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(5, 6, 18000);


-- Group 3


guest = LManager.GenGuest(male01);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = female03;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(7, 8, 30000);

-- Group 4

guest = LManager.GenGuest(male04);
guest.matchType = female03;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(9, 9, 40000);


-- Group 5

guest = LManager.GenGuest(female03);
guest.likes = {female01};
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = table1;
guest.percentRequestTissue = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = aunt;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(10, 13, 75000);

-- Group 6

guest = LManager.GenGuest(female04);
guest.matchType = table3;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = female04;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(14, 15, 110000);

-- Group 7

guest = LManager.GenGuest(male01);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = NOT_GUEST + male01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = female03;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(16, 18, 140000);



LManager:AdjustGuestTolerance(130);

LManager:SetLevelSetting ("speakerDelay", 700000); 
LManager:SetLevelSetting ("speakerChance", 30);

LManager:AddQuinnEvent( "fx/fx_chef_table_fire.lua", 660, 155, 100000 );



-- Set up the Level Settings
LManager:SetLevelNumber(2,2);
LManager:SetLevelScores(6800, 8500);
LManager:SetLevelTime(300000);


LManager:SetMusic("assets/audio/music/Big Band 4.ogg","assets/audio/music/Dance Dance 1.ogg","assets/audio/music/new_dance_1.ogg");
LManager:SetBackgroundImage("assets/images/bg_ballroom");
LManager:SetChairImage("assets/images/table/chair02");

-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );